/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class TickRate
extends UGen {
    private UGen audio;
    public UGen.UGenInput value = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    private float[] currentSample;
    private float[] nextSample;
    private float sampleCount;
    private boolean bInterpolate;

    public TickRate() {
        this(1.0f);
    }

    public TickRate(float f) {
        this.value.setLastValue(f);
        this.sampleCount = 0.0f;
        this.currentSample = new float[2];
        this.nextSample = new float[2];
        this.bInterpolate = false;
    }

    public final void setInterpolation(boolean bl) {
        this.bInterpolate = bl;
    }

    public final boolean isInterpolating() {
        return this.bInterpolate;
    }

    @Override
    protected void addInput(UGen uGen) {
        this.audio = uGen;
        this.audio.setAudioChannelCount(this.currentSample.length);
    }

    @Override
    protected void removeInput(UGen uGen) {
        if (this.audio == uGen) {
            this.audio = null;
        }
    }

    @Override
    protected void sampleRateChanged() {
        if (this.audio != null) {
            this.audio.setSampleRate(this.sampleRate());
        }
    }

    @Override
    public void setAudioChannelCount(int n) {
        if (this.currentSample.length != n) {
            super.setAudioChannelCount(n);
            this.currentSample = new float[n];
            this.nextSample = new float[n];
            if (this.audio != null) {
                this.audio.setAudioChannelCount(n);
                this.audio.tick(this.currentSample);
                this.audio.tick(this.nextSample);
                this.sampleCount = 0.0f;
            }
        }
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float f = this.value.getLastValue();
        if (f <= 0.0f) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = 0.0f;
            }
            return;
        }
        if (this.bInterpolate) {
            for (int i = 0; i < fArray.length; ++i) {
                float f2 = this.nextSample[i] - this.currentSample[i];
                fArray[i] = this.currentSample[i] + f2 * this.sampleCount;
            }
        } else {
            System.arraycopy(this.currentSample, 0, fArray, 0, fArray.length);
        }
        if (this.audio != null) {
            this.sampleCount += f;
            while (this.sampleCount >= 1.0f) {
                System.arraycopy(this.nextSample, 0, this.currentSample, 0, this.nextSample.length);
                this.audio.tick(this.nextSample);
                this.sampleCount -= 1.0f;
            }
        }
    }
}

